/* This script opens (at least 10 times and 10 s) a directory you chose on WB or
 * DOpus and measure the time. It is done to compare different versions of
 * icon.library by Peter Keunecke under same conditions on the same system.
 * For best results choose a large window with many (50+) visible icons. If
 * possible run it after a clean boot with no background tasks running.
 *
 *     $VER: OpenWin.rexx V1.8 (04.11.2014) by daxb@gmx.de and tomsmart1
 * Function: Measure how long it takes to open a window with many icons
 * Requires: rexxsupport.library (part of AmigaOS) and OS3.5+ or DOpus5
 *    Usage: Double click the icon or type "rx OpenWin.rexx" in CLI/Shell
*/

/* * * * * * * *  START OF USER-CONFIGURABLE SECTION  * * * * * * * */
dest = 1   /* Set to "0" if you want to test from Ram: (icons will be copied to it)
              If set to "1" test runs from the place you chose via requester */

minpasses = 10   /* 10 passes are the minimum default for open close the Icon test dir */

completetests = 3 /* 1 is default , it is the number of complete test passes to do */
                  /* if it set >1 the selected test (WB or DO) are completly repeated so many times */
                  /* as result you get the time for the fastest, slowest pass and the average over all passes */
/* * * * * * * * * END OF USER-CONFIGURABLE SECTION * * * * * * * * */

MyDebug = 0		/* 0 = Off, 1 = Errorhandling, >1 Errorhandling + Trace */
IF MyDebug > 1 THEN CALL TRACE('i')
IF MyDebug > 0 THEN DO
	SIGNAL ON ERROR
	SIGNAL ON SYNTAX
	SIGNAL ON NOVALUE
END
SIGNAL ON BREAK_C				/* If the user press CTRL+C */

envvar = 'ENVARC:OpenWin_dir'	/* Full path to ENV variable */
tempvar = 'T:OpenWin_dir'		/* Full path to temp variable */
LF = '0A'x						/* Line feed */

OPTIONS RESULTS ; ADDRESS COMMAND
CALL AddLibs()					/* Add rexxsupport.library to library list */
myPort = GetPort()				/* Set Workbench or DOpus5 port for testing */

/* Set default directory (SYS:) or last chose one (if exists and valid) */
IF EXISTS(envvar) THEN DO
	CALL OpenFile('envPath', envvar, 'R')		/* Open file (<logical name>, <filespec>, [<option>]) */
	oldDir = READLN('envPath')
	CALL CLOSE('envPath')
	oldDir = COMPRESS(oldDir, '"')
	ramdiskStr = 'Ram Disk:'					/* replace 'Ram Disk:" with 'Ram:'  in the path  tomsmart1 */
	IF COMPARE(oldDir, ramdiskStr) = 10 THEN DO /* test if the path contain 'Ram Disk:'  tomsmart1 */
		oldDir = DELSTR(oldDir, 4, 5) 	        /* remove ' Disk' form the string  that we have 'Ram:' only  tomsmart1 */
	END
	SELECT
		WHEN WORDS(oldDir) > 1 THEN oldDir = 'SYS:'
		WHEN LASTPOS(':', oldDir) = LENGTH(oldDir) THEN oldDir = 'SYS:'
		WHEN ~EXISTS(STRIP(oldDir, 'T', '/') || '.info') THEN oldDir = 'SYS:'
		OTHERWISE
	END
END
ELSE oldDir = 'SYS:'

/* Set directory via RequestFile */
myRC = CallExt('RequestFile DRAWER='|| oldDir 'TITLE="Choose a directory" DRAWERSONLY >' || tempvar)
IF myRC ~= 0 THEN DO
	SAY 'RequestFile Error! ->' tempvar
	EXIT
END
currentDir = GetDir(tempvar)

/* If a new directory was chosen then copy it to ENV:, else not */
IF COMPARE(oldDir, currentDir) ~= 0 THEN DO		/* Copy dir to ENVARC: if changed */
	myRC = CallExt('Copy' tempvar 'TO' envvar 'CLONE QUIET')
	myRC = CallExt('Wait 2')					/* We wait for the Filesystem when writing to HD */
END
myRC = CallExt('Delete' tempvar 'QUIET')

/* Copy test icon package to RAM: if not already exists and set as test dir */
IF dest = 0 THEN currentDir = IconsToRamAndSetAsDir(currentDir)

currentDir = STRIP(currentDir, 'T', '/')

/* Start test on Workbench or DOpus5 */
resultsum  = 0      /* set default for the complete test results  tomsmart1 */
slowresult = 0      /*                           "                          */
fastresult = 99999  /*                           "                          */
DO r = 1 TO completetests BY 1         /* begin the complete tests in the following block by the number of completetests  tomsmart1 */
  IF completetests > 1 THEN SAY LF || 'Start of complete test pass number:' r || LF  /* say the number of the completetest if we have more then 1  tomsmart1 */
  IF myPort = 'WORKBENCH' THEN testresult.r = WBTest(currentDir,minpasses)     /* IF WB then do the WBtest and get the average of it as result  tomsmart1 */
  ELSE testresult.r = DOpusTest(currentDir,minpasses,myPort)                   /* IF DO then do the DOtest and get the average of it as result  tomsmart1 */
  fastresult_old = fastresult                                                  /* store the old value */
  fastresult = MIN(fastresult_old, testresult.r)                               /* test the result is it faster as the last then save it as the new fastest  tomsmart1 */
  IF fastresult < fastresult_old THEN fasttest = r                             /* test if the result changed then save the complete test pass number  tomsmart1 */
  slowresult_old = slowresult                                                  /* store the old value */
  slowresult = MAX(slowresult_old, testresult.r)                               /* test if the result is slower as the last then save it as the new slowest  tomsmart1  */
  IF slowresult > slowresult_old THEN slowtest = r                             /* test if the result changed then save the complete test pass number  tomsmart1 */
  resultsum = resultsum + testresult.r                                         /* callulate the sum of the results  tomsmart1 */
END
IF completetests >1 THEN DO                                                    /* test if we have mor the 1 completetest if yes then show the results  tomsmart1 */
	SAY LF || 'Results over' completetests 'complete test passes:' || LF
	SAY 'Average: Fastest (test' RIGHT(fasttest, 2)') =' TRUNC(fastresult, 3) 'sec'
	SAY 'Average: Overall tests     =' TRUNC((resultsum / completetests), 3) 'sec'
	SAY 'Average: Slowest (test' RIGHT(slowtest, 2)') =' TRUNC(slowresult, 3) 'sec'
END

EXIT

WBTest: PROCEDURE EXPOSE MyDebug tempvar LF	/* EXPOSE <var> [<var>] is needed, else called sub functions don`t get/know the vars */
testDir = ARG(1)
minloops  = ARG(2)                      /* Set the minimal number of passes for the test  tomsmart1*/
sum = 0
ADDRESS 'WORKBENCH'						/* Workbench Port */
SAY 'Open/Close of:' || LF || testDir || LF
SAY 'Pass    seconds (1/50 s. accuracy)'
'WINDOWTOFRONT ROOT'                    /* Workbench window only to the front */
'WINDOW' testDir 'OPEN'					/* Prevent "wrong" time for   */
'WINDOW' testDir 'CLOSE'				/* the first call (dircache?) */
DO i = 1
	CALL TIME('R')						/* Reset timer */
	'WINDOW' testDir 'OPEN'				/* Open drawer */
	time.i = TIME('E')					/* Elapsed time */
	'WINDOW' testDir 'CLOSE'			/* Close drawer */
	sum = sum + time.i					/* Count times */
	SAY RIGHT(i, 3) || ':     ' time.i
	IF sum > 10  & i >= minloops THEN LEAVE		/* Leave if total > 10 seconds and >= minloops passes */
END
SAY LF || '  Total:' sum
SAY 'Average: ' TRUNC(sum / i, 3)		/* Truncates the result */
/* ugly but it works tomsmart1 */
subdirlevels = WORDS(TRANSLATE(testDir, ' ', ':/'))           /* seperrate the subdirnames with space and count the words to get the number of levels  tomsmart1 */
'WINDOW' testDir 'OPEN'                                       /* Workaround to avoid a lock on testDir */
IF subdirlevels > 1 THEN DO levels = subdirlevels TO 2 BY -1  /* check if we have subdirs if yes then repeat the following block as may (subdirslevel -1) because 1 = rootdir  tomsmart1 */
    'MENU WINDOW' testDir 'INVOKE WINDOW.OPENPARENT'          /* open parent Dir of testDir */
    'WINDOW' testDir 'CLOSE'                                  /* close child = testDir */
    testDir = STRIP(LEFT(testDir, MAX(LASTPOS(':', testDir), LASTPOS('/', testDir))), 'T', '/') /* remove the last subdir to get the parent for the next loop or the root if we have all subdirs */
END
'WINDOW' testDir 'CLOSE'                                      /* close the root dir this remove the lock of the Icon of OpenWinTemp dir */
/* end of the ugly workaround to remove to locks */
'WINDOWTOBACK ROOT'                     /* Workbench window only to back all other Windows to front as before WB to front  tomsmart1*/
RETURN (sum /i)                         /* Return the average  tomsmart1 */

DOpusTest: PROCEDURE EXPOSE MyDebug tempvar LF
testDir = ARG(1)
minloops  = ARG(2)                      /* Set the minimal number of passes for the test  tomsmart1*/
port = ARG(3)
sum = 0
ADDRESS VALUE port						/* DOPUS Port */
'DOPUS FRONT'							/* DOPUS window (and screen) to the front*/
SAY 'Open/Close of:' || LF || testDir || LF
SAY 'Pass    seconds (1/50 s. accuracy)'
'LISTER NEW FROMICON' testDir ; handle = RESULT		/* Prevent "wrong" time for   */
'LISTER WAIT' handle ; 'LISTER CLOSE' handle		/* the first call (dircache?) */
IF 'LISTER QUERY' handle 'BUSY' = 1 THEN 'LISTER WAIT' handle
DO i = 1
	CALL TIME('R')						/* Reset timer */
	'LISTER NEW FROMICON' testDir ; handle = RESULT		/* Open drawer */
	'LISTER WAIT' handle				/* Wait for it */
	time.i = TIME('E')					/* Elapsed time */
	'LISTER CLOSE' handle				/* Close drawer */
	IF 'LISTER QUERY' handle 'BUSY' = 1 THEN 'LISTER WAIT' handle
	sum = sum + time.i					/* Count times */
	SAY RIGHT(i, 3) || ':     ' time.i
	IF sum > 10  & i >= minloops THEN LEAVE		/* Leave if total > 10 seconds and >= minloops passes */
END
SAY LF || '  Total:' sum
SAY 'Average: ' TRUNC(sum / i, 3)		/* Truncates the result */
RETURN (sum /i)                         /* Return the average  tomsmart1 */

GetDir:	PROCEDURE EXPOSE MyDebug tempvar
file = ARG(1)
CALL OpenFile('userPath', file, 'R')			/* Open file (<logical name>, <filespec>, [<option>]) */
directory = READLN('userPath')
CALL CLOSE('userPath')
directory = COMPRESS(directory, '"')
/* replace 'Ram Disk:' with 'Ram:'  in the path  tomsmart1 */
ramdiskStr='Ram Disk:'
IF COMPARE(directory,ramdiskStr) = 10 THEN DO	/* test if the path contain 'Ram Disk:'  tomsmart1 */
	directory = DELSTR(directory, 4, 5)         /* remove ' Disk' form the string  that we have 'Ram:' only  tomsmart1 */
END
IF WORDS(directory) > 1 THEN DO								/* Check for space(s) in path */
	SAY 'Spaces in path aren`t supported!'
	EXIT
END
IF LASTPOS(':', directory) = LENGTH(directory) THEN DO		/* Check for root */
	SAY 'No root please! Choose a drawer.'
	EXIT
END
IF ~EXISTS(STRIP(directory, 'T', '/') || '.info') THEN DO	/* Check for icon. We need it (window size info) for testDir. */
	SAY 'The drawer has no icon! Please add an icon for:'
	SAY STRIP(directory, 'T', '/')
	EXIT
END
RETURN directory

OpenFile: PROCEDURE EXPOSE MyDebug tempvar
logicalName = ARG(1)			/* ARG 1 = is a logical name that will be used by other functions */
filespec = ARG(2)				/* ARG 2 is a device or full path of a file to open */
option = ARG(3)					/* ARG 3 can be (R)ead, (W)rite or (A)ppend */
IF ~OPEN(logicalName, filespec, option) THEN DO
	SAY "Can't open" filespec "(" || option || ")"
	CALL CLOSE(logicalName)
	EXIT
END
RETURN

IconsToRamAndSetAsDir: PROCEDURE EXPOSE MyDebug tempvar	/* EXPOSE MyDebug is needed, else CallExt() don`t get/know MyDebug */
currentDir = ARG(1)
pathtoram = 'RAM:OpenWinTemp'					/* Just a path to RAM: */
copySource = STRIP(currentDir, 'T', '/') || '#?'
IF ~EXISTS(pathtoram) THEN DO
	IF ~MAKEDIR(pathtoram) THEN DO
		SAY 'MakeDir error!'
		EXIT
	END
END
ramDirStr = SHOWDIR(pathtoram, 'DIR')			/* Get current test dir from RAM:<pathtoram>/ */
a = TRIM(TRANSLATE(currentDir, ' ', ':/'))
testDirStr = WORD(a, WORDS(a))					/* Get current test dir from var currentDir */
IF COMPARE(ramDirStr, testDirStr) > 0 THEN DO	/* If dir names differ delete old and copy new */
	IF SHOWDIR(pathtoram, 'DIR') ~= '' THEN DO
		SAY 'Delete' pathtoram || '/' || ramDirStr
		myRC = CallExt('Delete' pathtoram || '/#? ALL FORCE QUIET')
	END
	SAY 'Copy' currentDir 'TO' pathtoram
	myRC = CallExt('Copy' copySource 'TO' pathtoram 'ALL CLONE QUIET')
END
currentDir = pathtoram || '/' || testDirStr		/* Make test dir */
IF ~EXISTS(currentDir || '.info') THEN DO		/* Check for icon again if the user delete it between two tests. */
	SAY 'The drawer has no icon! Please add an icon for:'
	SAY currentDir
	EXIT
END
RETURN currentDir

GetPort: PROCEDURE EXPOSE MyDebug tempvar	/* EXPOSE MyDebug is needed, else CallExt() don`t get/know MyDebug */
myPort = ''
IF SHOW('P', 'WORKBENCH') & SHOW('P', 'Directory Opus') THEN DO
	myRC = CallExt('RequestChoice >ENV:OpenWinChoice "OpenWin.rexx" "WB and DOpus5 are running.*NChoose WB or DOpus" "_WB|D_Opus"')
	CALL OpenFile('reqCh', 'ENV:OpenWinChoice', 'R')	/* Open file (<logical name>, <filespec>, [<option>]) */
	ReqChRC = READLN('reqCh')
	CALL CLOSE('reqCh')
	IF ~DELETE('ENV:OpenWinChoice') THEN SAY 'Error while delete ENV:OpenWinChoice'
	IF ReqChRC = 1 THEN myPort = 'WORKBENCH'
	ELSE myPort = 'dopus'
END
ELSE DO
	IF SHOW('P', 'WORKBENCH') THEN myPort = 'WORKBENCH'
	IF SHOW('P', 'Directory Opus') THEN myPort = 'dopus'
END
IF myPort = '' THEN DO
	SAY 'No Workbench or DOpus5 ARexx message port!'
	SAY 'Requires workbench.library 44.1106 (24.8.99) or DOpus5'
	EXIT
END
IF myPort = 'dopus' THEN DO					/* We don`t know if port 'DOPUS.x' belongs to DOpus5 */
	DO i = 1								/* So we check it... */
		IF SHOW('P', 'DOPUS.' || i) THEN DO
			currentPort = 'DOPUS.' || i
			ADDRESS	VALUE currentPort		/* Try DOPUS Port i */
			'DOPUS VERSION' ; ver = RESULT	/* Get DOpus version */
			ADDRESS							/* Switch back to ADDRESS COMMAND */
			IF WORD(ver, 1) = 5 THEN DO		/* IF version = 5 then port found */
				myPort = currentPort
				dopusFivePortExists = 1
				LEAVE						/* DOpus5 port found so leave */
			END
		END
		ELSE LEAVE							/* Leave if no more DOpus ports exists */
	END
	IF dopusFivePortExists ~= 1 THEN DO		/* No DOpus5 port found so we exit */
		SAY 'DOpus 5 port not found!'
		EXIT
	END
END
RETURN myPort

/* Check/Add libs */
AddLibs: PROCEDURE EXPOSE MyDebug tempvar
libs = 'rexxsupport.library'
DO i = 1 TO WORDS(libs)
	IF ~SHOW('L', WORD(libs, i)) THEN DO
		IF ADDLIB(WORD(libs, i), 0, -30, 0) = 0 THEN DO
			ADDRESS COMMAND 'Run >NIL: C:RequestChoice "OpenWin.rexx" "Can`t open" WORD(libs, i) "_OK"'
			EXIT
		END
	END
END
RETURN

/* Call the Command in Arg(1) as external Program */
CallExt:
Command = ARG(1)
IF MyDebug > 0 THEN SIGNAL OFF Error
Command
IF MyDebug > 0 THEN SIGNAL ON Error
RETURN (RC)

BREAK_C:
SAY 'User abort by CTRL+C!'
IF EXISTS(tempvar) THEN ADDRESS COMMAND 'Delete' tempvar 'QUIET'
EXIT

Error:
Syntax:
NoValue:
IF RC ~= "RC" THEN i = RC
ELSE i = 0
ECHO
ECHO "Error" i "(" || ERRORTEXT(i) || ") in Line" SIGL
ECHO "SourceLine =" SOURCELINE(SIGL)
EXIT